<?php
add_action( 'admin_enqueue_scripts', 'add_sendy_admin_scripts' );
add_action( 'admin_menu', 'sendy_admin_page' );
function add_sendy_admin_scripts( $hook ) {
	global $post;
	if ( $hook == 'post-new.php' || $hook == 'post.php' ) {
		if ( 'swp_forms' === $post->post_type ) {
			wp_enqueue_style( 'sendy_admin_css', SENDY_WIDGET_PRO_URL.'/css/admin/admin.css' );
			// Layout Builder
			wp_enqueue_style( 'wp-color-picker' );
			wp_enqueue_style( 'gridster', SENDY_WIDGET_PRO_URL.'/css/admin/gridster.css' );
			wp_enqueue_style( 'nouislider', SENDY_WIDGET_PRO_URL.'/css/admin/jquery.nouislider.min.css' );
			wp_enqueue_script( 'nouislider', SENDY_WIDGET_PRO_URL.'/js/admin/jquery.nouislider.all.min.js' );
			wp_enqueue_script( 'gridster', SENDY_WIDGET_PRO_URL.'/js/admin/gridster.js' );
			wp_enqueue_script( 'sendy-layout-builder', SENDY_WIDGET_PRO_URL.'/js/admin/layout-builder.js', array( 'jquery', 'gridster', 'nouislider', 'wp-color-picker' ) );
		}
	} elseif ( $hook == 'edit.php' ) {
		$type = empty( $post->post_type )?$_GET['post_type']:$post->post_type;
		if ( 'swp_forms' === $type ) {
			wp_enqueue_style( 'sendy_admin_css', SENDY_WIDGET_PRO_URL.'/css/admin/admin.css' );
			add_action( 'admin_head', 'swp_add_info_sidebar' );
			add_action( 'admin_footer', 'swp_add_info_sidebar_html' );
			add_filter( 'page_row_actions', 'swp_remove_edit_trash_links', 10, 2 );
			add_filter( 'manage_posts_columns' , 'swp_remove_date_coloumn' );
		}
	} elseif ( 'swp_forms_page_sendy-widget-pro-settings' == $hook ) {
		// settings page
		//
	   // wp_enqueue_style( 'materialize_icons', 'https://fonts.googleapis.com/icon?family=Material+Icons' );
		// wp_enqueue_style( 'materialize', SENDY_WIDGET_PRO_URL.'/css/admin/materialize.css' );
		wp_enqueue_style( 'sendy_admin_css', SENDY_WIDGET_PRO_URL.'/css/admin/admin.css' );
		// wp_enqueue_script( 'materialize',  SENDY_WIDGET_PRO_URL.'/js/admin/materialize.js' );
		wp_enqueue_script( 'sendy-settings', SENDY_WIDGET_PRO_URL.'/js/admin/settings.js' );
	}
}
/*   Add Page  */
function sendy_admin_page() {
	add_submenu_page( 'edit.php?post_type=swp_forms', 'Settings', 'Settings', 'manage_options', 'sendy-widget-pro-settings', 'sendy_widget_admin' );
}
function sendy_widget_admin() {
	if ( isset( $_GET['id'] ) && $_GET['sendy_action'] == 'delete' ) {
		delete_sendy_list();
	}
	if ( isset( $_POST['save_options'] ) ) {
		save_sendy_options();
	}
	//var_dump(isset($_POST));die;
	if ( isset( $_POST['swp_custom_field_form'] ) ) {
		save_sendy_custom_fields();
	}
	if ( isset( $_GET['id'] ) && $_GET['sendy_action'] == 'delete_custom' ) {
		delete_sendy_custom_fields();
	}
?>
<div class="wrap row">
	<div id="sendy-tabs" class="col s12">
		<ul class="tabs">
			<li class="tab col s2 active"><a class="" href="#sendy-tabs-1">General Settings</a></li>
			<li class="tab col s2"><a class="" href="#sendy-tabs-5">Custom Fields</a></li>
			<li class="tab col s2"><a class="" href="#sendy-tabs-3">Translation (Deprecated)</a></li>
			<li class="tab col s2"><a class="" href="#sendy-tabs-2">Generate Shortcode (Deprecated)</a></li>

			<li class="tab col s2"><a class="" href="#sendy-tabs-4">Help</a></li>
			<div style="clear:both" ></div>
		</ul>
		<div id="sendy-tabs-1" style="display:block"  class="tab-content">
			<?php if ( isset( $_POST['save_options'] ) ) { ?>
			<div class="updated"> <p>Settings saved successfully</p></div>
			<?php
	}
	$sendy_url=get_option( 'sendy_url' );
?>
			<form action="" method="post">
				<div id="poststuff">
					<h2 style="margin:0px"></h2>
					<div id="postbox-container-2" class="postbox-container">
						<div id="advanced-sortables" class="meta-box-sortables ui-sortable">
							<div class="postbox swp_form_fields sendy-setting-postbox">
								<div class="handlediv" title="Click to toggle"><br></div>
								<h3 class="hndle ui-sortable-handle"><div class=" dashicons-before dashicons-admin-settings"><span> Configuration</span></div></h3>
								<div class="inside">
									<table class="form-table">
										<tr valign="top">
											<th scope="row">Sendy API Key<span style="color:red">*</span></th>
											<td>
												<input type="text" name="api_key" class="regular-text" value="<?php echo get_option( 'sendy_api_key' ) ?>">
											</td>
										</tr>
										<tr valign="top">
											<th scope="row">Sendy Installation Url<span style="color:red">*</span></th>
											<td>
												<input type="text" name="sendy_url" class="regular-text" value="<?php echo $sendy_url; ?>">
												<?php if ( ! empty( $sendy_url ) ) { ?>
												<a name="view" class="button-secondary" target="_blank" href="<?php echo $sendy_url; ?>">View</a>
												<?php } ?>
											</td>
										</tr>
									</table>
									<?php show_list_counts(); ?>
									<br />
									<input  name="save_options" type="submit" class="button-primary" value="<?php esc_attr_e( 'Save Settings' ); ?>" />
								</div>
								</div>
								<?php sendy_show_display_settings(); ?>
								<div style="clear:both;"></div>
								<input  name="save_options" type="submit" class="button-primary" value="<?php esc_attr_e( 'Save Settings' ); ?>" />

						</div>
					</div>
					</div>
					</form>
				</div>
				<div id="sendy-tabs-2"  class=" tab-content">
					<p>This shortcode is deprecated and will be removed in future. Please create form using new form builder and use that shortcode.</p>
					<h2>Subscribe Form Shortcode </h2>
					<input id="shortcode_box" type="text" readonly class="large-text" value="[subscribe-sendy-form]">
					<form id="sendy-shortcode-form" >
						<table class="form-table"  >
							<tbody>
								<tr valign ="top">
									<th scope="row">Select list <span style="color:red">*</span> </th>
									<td>
										<?php

										 $sendy_lists=get_option( 'sendy_lists' );
										 if ( $sendy_lists ) {
											 # code...

										foreach ( $sendy_lists as $list_id => $list_name ) {  ?>
										<p><input type="checkbox" class="filled-in" id="check_shortcode_list<?php echo $list_id; ?>" name="listid[]"  value="<?php echo $list_id; ?>"> <label for="check_shortcode_list<?php echo $list_id; ?>"><?php echo $list_name; ?></label></p>
										<?php  }

										}?>
										<p class="description">Please select atleast one list for shortcode to work </p>
									</td>
								</tr>
								<tr valign ="top">
									<th scope="row"> Name Field </th>
									<td>
										<input type="checkbox" class="filled-in" name="showname" id="check_showname" >
										<label for="check_showname">Show Name field in the form?</label>
									</td>
								</tr>
								<tr valign ="top">
									<th scope="row">Captcha </th>
									<td>
										<input type="checkbox" class="filled-in" name="showcaptcha" id="check_showcaptcha" ><label  for="check_showcaptcha">Enable captcha on the form?</label>
									</td>
								</tr>
								<tr valign ="top">
									<th scope="row"> Terms and condition  </th>
									<td>
										<input type="checkbox" class="filled-in" name="showterms" id="check_showterms"  ><label  for="check_showterms">Show Terms and conditions checkbox?</label>
									</td>
								</tr>
								<tr valign ="top">
									<th scope="row">Subscriber Count  </th>
									<td>
										<input type="checkbox" class="filled-in" name="showsubscribers" id="check_showsubscribers"><label for="check_showsubscribers">Show total subscribers count? </label>
									</td>
								</tr>
							</tbody>
						</table>
					</form>
					<form id="sendy-unsubscribe-shortcode-form" >
						<table class="form-table"  >
							<tbody>
								<tr valign ="top">
									<th colspan="2" ><h2>Unsubscribe  Form Shortcode </h2> </th>
								</tr>
								<tr valign ="top">
									<td colspan="2" >
										Shortcode:<input id="unshortcode_box" type="text" readonly class="large-text" value="[unsubscribe-sendy-form]">
									</td>
								</tr>
								<tr valign ="top">
									<th scope="row">Select list <span style="color:red">*</span> </th>
									<td>
										<?php
										  if ( $sendy_lists ) {
											 # code...
										 foreach ( $sendy_lists as $list_id => $list_name ) {  ?>
										<p><input type="checkbox" class="filled-in" name="listid[]" id="check_unsubscibe<?php echo $list_id; ?>"  value="<?php echo $list_id; ?>"> <label for="check_unsubscibe<?php echo $list_id; ?>"><?php echo $list_name; ?></label></p>
										<?php  }
										} ?>
										<p class="description">Please select atleast one list for shortcode to work </p>
									</td>
								</tr>
							</tbody>
						</table>
					</form>
				</div>
				<div id="sendy-tabs-3" class="tab-content">
					<form method="post" action="options.php">
						<?php settings_fields( 'sendy_translation_settings' ); ?>
						<?php do_settings_sections( 'sendy-widget-pro-settings' ); ?>
						<?php submit_button(); ?>
					</form>
				</div>
				<div id="sendy-tabs-4" class="tab-content">
					<p class="discussion"> Have question ? Please submit a support ticket <a target="_blank" href="https://webholics.org/contact">website</a></p>
				</div>
				<div id="sendy-tabs-5" class="tab-content">
					<?php do_action( 'sendy_custom_field_tab_content' ) ?>
				</div>
			</div>
		</div>
		<?php     }
function api_setting_section_callback() { ?>
		<div id="row-add-new-list" style="display:none">
			<table class="form-table">
				<tr    valign="top">
					<td colspan="2" style="padding:0px" >
						<table class="form-table" >
							<tr valign="top">
								<th scope="row">List Name</code></th>
								<td>
									<input type="text" name="new_list_name" class="regular-text" value="">
								</td>
							</tr>
							<tr valign="top">
								<th scope="row">List ID</code></th>
								<td>
									<input type="text" name="new_list_id" class="regular-text" value="">
								</td>
							</tr>
							<tr>
								<td colspan="2" >
									<div style="margin-left:209px;margin-bottom:0px;">
										<input name="save_options" type="submit" class="button-primary" value="<?php esc_attr_e( 'ADD LIST' ); ?>" />
										<input id="cancel_options" type="button" class="button-secondary" value="<?php esc_attr_e( 'Cancel' ); ?>" />
									</div>
								</td>
							</tr>
						</table>
					</td>
				</tr>
			</table>
		</div>
		<?php }
function show_list_counts() { ?>
		<h2>Lists <a class="add-new-list-button add-new-h2" href="javascript:void(0)">Add New List</a></h2>
		<?php api_setting_section_callback(); ?>
		<table class="widefat" style="margin:35px 0px;">
			<thead>
				<tr>
					<th class="row-title">Sr No.</th>
					<th>List Name</th>
					<th class="row-title">List ID</th>
					<th>Subscribers</th>
					<th>Action</th>
				</tr>
			</thead>
			<tbody>
				<?php
	$sendy_url=get_option( 'sendy_url' );
	$sendy_api_key=get_option( 'sendy_api_key' );
	$sendy_lists=get_option( 'sendy_lists' );
	if ( $sendy_lists ) {
		$i=1;
		$url=$sendy_url.'/api/subscribers/active-subscriber-count.php';
		foreach ( $sendy_lists as $list_id => $list_name ) {
			echo '<tr>';
			$response= wp_remote_post( $url, array( 'body'=>array( 'api_key'=>$sendy_api_key, 'list_id'=>$list_id ) ) );
			if ( is_wp_error( $response ) ) {
				$error_message = $response->get_error_message();
				$count=$error_message;
			} else {
				$count=$response['body'];
			}
			echo "<td>$i</td>";
			echo "<td> $list_name </td>";
			echo "<td> $list_id </td>";
			echo "<td>$count</td>";
			echo "<td><a href='edit.php?post_type=swp_forms&page=sendy-widget-pro-settings&sendy_action=delete&id=$list_id'>Delete</a></td>";
			$i++;
			echo '</tr>';
		}
	} else {
		echo "<td colspan='5'>No list saved yet. </td>";
	}
?>
			</tr>
		</tbody>
		<tfoot>
		<tr>
			<th class="row-title">Sr No.</th>
			<th>List Name</th>
			<th class="row-title">List ID</th>
			<th>Subscribers</th>
			<th>Action</th>
		</tr>
		</tfoot>
	</table>
	<?php  }
function sendy_show_display_settings() {
	$sendy_lists=get_option( 'sendy_lists' );
	$sendy_on_register=get_option( 'sendy_on_register' );
	$sendy_woo_checkout_check=get_option( 'sendy_woo_checkout_check' );
	$sendy_woo_checkout_page_lists=get_option( 'sendy_woo_checkout_page_lists' );
	$sendy_edd_checkout_check=get_option( 'sendy_edd_checkout_check' );
	$sendy_edd_checkout_page_lists=get_option( 'sendy_edd_checkout_page_lists' );
	$sendy_register_page_lists=get_option( 'sendy_register_page_lists' );
	$sendy_buddypress_check=get_option( 'sendy_buddypress_check' );
	$sendy_buddypress_lists=get_option( 'sendy_buddypress_lists' );
?>
	<div class="postbox swp_form_fields clearcard">
		<div class="handlediv" title="Click to toggle"><br></div>
		<h3 class="hndle ui-sortable-handle"><div class=" dashicons-before dashicons-admin-settings">
		<span> Basic Settings</span></div></h3>
		<div class="inside">
			<table class="form-table" >
				<tbody>
					<tr valign ="top">
						<th scope="row">Redirect Url</th>
						<td><input type="text" class="regular-text" name="sendy_redirect_url" value="<?php echo get_option( 'sendy_redirect_url' ) ?>">
						<p class="description">Page url where users should be redirected after user is added successfully to the list </p>
					</td>
				</tr>
				<tr valign ="top">
					<th scope="row">Terms & Conditions page link </th>
					<td><input type="text" class="regular-text" name="sendy_terms_link" value="<?php echo get_option( 'sendy_terms_link' ) ?>">
					<p class="description">Link of the page having your terms and privacy policy </p>
				</td>
			</tr>
			<tr valign ="top">
				<th scope="row">Subscribe from Register Page </th>
				<td>
					<input id="rad_sendy_on_register_disable" class="sendy_on_register_disable" type="radio" value="disable" name="sendy_on_register" <?php checked( $sendy_on_register, 'disable', true );  ?> >
					<label for="rad_sendy_on_register_disable">Disable </label>
					<input id="rad_sendy_on_register_on"  class="sendy_on_register" type="radio" value="on" name="sendy_on_register" <?php checked( $sendy_on_register, 'on', true );   ?> >
					<label  for="rad_sendy_on_register_on" >Show Checkbox on register page </label>
					<input id="rad_sendy_on_register_direct"  class="sendy_on_register" type="radio" value="direct" name="sendy_on_register" <?php  checked( $sendy_on_register, 'direct', true );   ?> >
					<label  for="rad_sendy_on_register_direct" >Signup directly (won't show checkbox) </label>
					<div id="register_lists_row" <?php  echo $sendy_on_register!='disable'?'style="display:block"':'style="display:none"'  ?>>
						<p class="description">Select Lists</p>
						<?php
							if ( $sendy_lists ) {
								foreach ( $sendy_lists as $list_id => $list_name ) { ?>
												<input type="checkbox" class="filled-in" id="check_sendy_register_page_lists<?php echo $list_id ?>"  name="sendy_register_page_lists[]" value="<?php echo $list_id ?>"  <?php if ( is_array( $sendy_register_page_lists ) ) { echo  in_array( $list_id, $sendy_register_page_lists )?'checked' : ''; } ?>  >
												<label for="check_sendy_register_page_lists<?php echo $list_id ?>"><?php echo $list_name ?></label>
												<?php
								}
							}
						?>
					</div>
				</td>
			</tr>
		</tbody>
	</table>
</div></div>

<!-- Recaptcha -->
<?php
	$sendy_recaptcha = get_option('sendy_recaptcha');
?>
 <div class="postbox swp_form_fields clearcard">
			<div class="handlediv" title="Click to toggle"><br></div>
			<h3 class="hndle ui-sortable-handle">
			<div class=" dashicons-before dashicons-admin-settings">
			<span> reCAPTCHA Settings </span></div></h3>
			<div class="inside">
				<table class="form-table" >
					<tbody>
						<tr valign ="top">
							<th scope="row">reCAPTCHA Site Key</th>
							<td>
							   <input type="text" name="sendy_recaptcha[site_key]" class="regular-text" value="<?php echo isset($sendy_recaptcha['site_key'])?$sendy_recaptcha['site_key']:''; ?>">
								<p class="description">Get a site key for your domain by registering <a target="_blank" href="https://www.google.com/recaptcha/intro/index.html">here</a></p>
							</td>
						</tr>
						<tr valign ="top">
							<th scope="row">reCAPTCHA Secret Key</th>
							<td>
							   <input type="text" name="sendy_recaptcha[secret_key]" class="regular-text" value="<?php echo isset($sendy_recaptcha['secret_key'])?$sendy_recaptcha['secret_key']:''; ?>">

							</td>
						</tr>
						<tr valign ="top">
							<th scope="row">reCAPTCHA Language</th>
							<td>
							   <input type="text" name="sendy_recaptcha[language]" class="regular-text" value="<?php echo isset($sendy_recaptcha['language'])?$sendy_recaptcha['language']:''; ?>">
							<p class="description">e.g. en, da - Language used by reCAPTCHA. To get the code for your language click <a target="_blank" href="https://developers.google.com/recaptcha/docs/language">here</a></p>
							</td>
						</tr>
					</tbody>
				</table>
			</div></div>
<div class="postbox swp_form_fields clearcard">
	<div class="handlediv" title="Click to toggle"><br></div>
	<h3 class="hndle ui-sortable-handle"><div class=" dashicons-before dashicons-admin-settings">
	<span> Woocommerce Settings </span></div></h3>
	<div class="inside">
		<table class="form-table" >
			<tbody>
				<tr valign ="top">
					<th scope="row">Show checkbox on Checkout Page</th>
					<td>
						<input type="checkbox" class="filled-in" id="sendy_woo_checkout_check" name="sendy_woo_checkout_check"    <?php  echo $sendy_woo_checkout_check!=''?'checked=checked':''  ?>  >
						<label for="sendy_woo_checkout_check">Allow users to signup for your newsletter on woocoomerce checkout page. </label>
						<div id="woo_lists_row" <?php  echo $sendy_woo_checkout_check==''?'style="display:none"':''  ?>>
							<p class="description">Select Lists </p>
							<?php
	if ( $sendy_lists ) {
		foreach ( $sendy_lists as $list_id => $list_name ) {
?>
							<input id="check_sendy_woo_checkout_page_lists<?php echo $list_id ?>" type="checkbox" class="filled-in" name="sendy_woo_checkout_page_lists[]" value="<?php echo $list_id ?>"  <?php if ( is_array( $sendy_woo_checkout_page_lists ) ) { echo  in_array( $list_id, $sendy_woo_checkout_page_lists )?'checked' : ''; } ?>  >
							<label for="check_sendy_woo_checkout_page_lists<?php echo $list_id ?>"><?php echo $list_name ?></label>
							<?php
		}
	}
?>
						</div>
					</td>
				</tr>
			</tbody>
		</table>
	</div></div>
	<div class="postbox swp_form_fields clearcard">
		<div class="handlediv" title="Click to toggle"><br></div>
		<h3 class="hndle ui-sortable-handle"><div class=" dashicons-before dashicons-admin-settings">
		<span> Easy Digital Downloads Settings </span></div></h3>
		<div class="inside">
			<table class="form-table" >
				<tbody>
					<tr valign ="top">
						<th scope="row">Show checkbox on Checkout Page</th>
						<td>
							<input type="checkbox" class="filled-in" id="sendy_edd_checkout_check" name="sendy_edd_checkout_check"    <?php  echo $sendy_edd_checkout_check!=''?'checked=checked':''  ?>  >
							<label for="sendy_edd_checkout_check">Allow users to signup for your newsletter on EDD checkout page. </label>
							<div id="edd_lists_row" <?php  echo $sendy_edd_checkout_check==''?'style="display:none"':''  ?>>
								<p class="description">Select Lists </p>
								<?php
	if ( $sendy_lists ) {
		foreach ( $sendy_lists as $list_id => $list_name ) {
?>
								<input id="check_sendy_edd_checkout_page_lists<?php echo $list_id ?>" type="checkbox" class="filled-in" name="sendy_edd_checkout_page_lists[]" value="<?php echo $list_id ?>"  <?php if ( is_array( $sendy_edd_checkout_page_lists ) ) { echo  in_array( $list_id, $sendy_edd_checkout_page_lists )?'checked' : ''; } ?>  >
								<label for="check_sendy_edd_checkout_page_lists<?php echo $list_id ?>"><?php echo $list_name ?></label>
								<?php
		}
	}
?>
							</div>
						</td>
					</tr>
				</tbody>
			</table>
		</div>
		</div>
		<div class="postbox swp_form_fields clearcard">
			<div class="handlediv" title="Click to toggle"><br></div>
			<h3 class="hndle ui-sortable-handle"><div class=" dashicons-before dashicons-admin-settings">
			<span> BuddyPress Settings </span></div></h3>
			<div class="inside">
				<table class="form-table" >
					<tbody>
						<tr valign ="top">
							<th scope="row">Show checkbox on Register Page</th>
							<td>
								<input type="checkbox" class="filled-in" id="sendy_buddypress_check" name="sendy_buddypress_check"    <?php  echo $sendy_buddypress_check!=''?'checked=checked':''  ?>  >
								<label for="id="sendy_buddypress_check"">Allow users to signup for your newsletter from BuddyPress register page . </label>
								<div id="buddypress_lists_row" <?php  echo $sendy_buddypress_check==''?'style="display:none"':''  ?>>
									<p class="description">Select Lists</p>
									<?php
	if ( $sendy_lists ) {
		foreach ( $sendy_lists as $list_id => $list_name ) {
?>
									<input id="check_sendy_buddypress_lists<?php echo $list_id ?>" type="checkbox" class="filled-in" name="sendy_buddypress_lists[]" value="<?php echo $list_id ?>"  <?php if ( is_array( $sendy_buddypress_lists ) ) { echo  in_array( $list_id, $sendy_buddypress_lists )?'checked' : ''; } ?>  >
									<label for="check_sendy_buddypress_lists<?php echo $list_id ?>"><?php echo $list_name ?></label>
									<?php
		}
	}
?>
								</div>
							</td>
						</tr>
					</tbody>
				</table>
			</div></div>


			<?php }
