<?php

/**
 * Adds a box to the main column on the Post and Page edit screens.
 */
function swp_admin_add_meta_box() {

	add_meta_box( 'swp_form_layout', __( 'Form layout', 'swp' ), 'swp_admin_form_fields', 'swp_forms' );
	add_meta_box( 'swp_form_general_setting', __( 'General Settings', 'swp' ), 'swp_admin_form_general_settings', 'swp_forms' );
	add_meta_box( 'swp_form_translation_settings', __( 'Translations Settings', 'swp' ), 'swp_admin_form_translation_settings', 'swp_forms' );
	add_meta_box( 'swp_form_design', __( 'Form Design', 'swp' ), 'swp_admin_form_design', 'swp_forms' );
	add_meta_box( 'swp_label_design', __( 'Label Design', 'swp' ), 'swp_admin_label_design', 'swp_forms' );
	add_meta_box( 'swp_field_design', __( 'Field Design', 'swp' ), 'swp_admin_field_design', 'swp_forms' );
	add_meta_box( 'swp_submit_design', __( 'Submit Button Design', 'swp' ), 'swp_admin_submit_design', 'swp_forms' );
	//add_meta_box( 'swp_error_design', __( 'Error Text Design', 'swp' ), 'swp_admin_error_design', 'swp_forms' );
}
add_action( 'add_meta_boxes', 'swp_admin_add_meta_box' );

function swp_admin_form_fields( $post ) {


	// Add a nonce field so we can check for it later.
	wp_nonce_field( 'swp_meta_form_field_meta_box', 'swp_meta_form_field_meta_box_nonce' );

		do_action( 'swp_form_layout_settings', $post->ID );

}

function swp_admin_form_translation_settings( $post ) {


	// Add a nonce field so we can check for it later.
	wp_nonce_field( 'swp_meta_form_field_meta_box', 'swp_meta_form_field_meta_box_nonce' );

		do_action( 'swp_form_translation_settings', $post->ID );

}

function swp_admin_form_general_settings( $post ) {

	// Add a nonce field so we can check for it later.
	wp_nonce_field( 'swp_meta_form_field_meta_box', 'swp_meta_form_field_meta_box_nonce' );
	do_action( 'swp_form_general_settings', $post->ID );
}




function swp_admin_form_design( $post ) {

	// Add a nonce field so we can check for it later.
	wp_nonce_field( 'swp_meta_form_field_meta_box', 'swp_meta_form_field_meta_box_nonce' );
	do_action( 'swp_form_design_settings', $post->ID );
}
function swp_admin_label_design( $post ) {


	// Add a nonce field so we can check for it later.
	wp_nonce_field( 'swp_meta_form_field_meta_box', 'swp_meta_form_field_meta_box_nonce' );

	do_action( 'swp_label_design_settings', $post->ID );

}

function swp_admin_field_design( $post ) {

	// Add a nonce field so we can check for it later.
	wp_nonce_field( 'swp_meta_form_field_meta_box', 'swp_meta_form_field_meta_box_nonce' );

	do_action( 'swp_field_design_settings', $post->ID );

}

function swp_admin_submit_design( $post ) {

	// Add a nonce field so we can check for it later.
	wp_nonce_field( 'swp_meta_form_field_meta_box', 'swp_meta_form_field_meta_box_nonce' );

	do_action( 'swp_submit_design_settings', $post->ID );

}

function swp_admin_error_design($post){
		do_action( 'swp_admin_error_design', $post->ID );
}

