<?php


add_action( 'init', 'swp_register_admin_post_type' );
/**
 * Register a book post type.
 *
 * @link http://codex.wordpress.org/Function_Reference/register_post_type
 */
function swp_register_admin_post_type() {
	$labels = array(
		'name'               => _x( 'Sendy Widget Pro', 'Sendy Widget Pro Forms', 'swp' ),
		'singular_name'      => _x( 'Sendy Widget Pro', 'Sendy Widget Pro Forms', 'swp' ),
		'menu_name'          => _x( 'Sendy Widget Pro', 'admin menu', 'swp' ),
		'name_admin_bar'     => _x( 'Sendy Widget Pro', 'add new on admin bar', 'swp' ),
		'add_new'            => _x( 'Add New', 'form', 'swp' ),
		'add_new_item'       => __( 'Add New Form', 'swp' ),
		'new_item'           => __( 'New Form', 'swp' ),
		'edit_item'          => __( 'Edit Form', 'swp' ),
		'view_item'          => __( 'View Form', 'swp' ),
		'all_items'          => __( 'All Forms', 'swp' ),
		'search_items'       => __( 'Search Forms', 'swp' ),
		'parent_item_colon'  => __( 'Parent Forms:', 'swp' ),
		'not_found'          => __( 'No Form found.', 'swp' ),
		'not_found_in_trash' => __( 'No Forms found in Trash.', 'swp' )
	);

	$args = array(
		'labels'             => $labels,
		'public'             => true,
		'publicly_queryable' => true,
		'show_ui'            => true,
		'hierarchical' => true,
		'rewrite' => false,
		'query_var' => "swp_forms",
		'show_in_menu' => true,
		'menu_icon'=>'dashicons-index-card',
		'supports'           => array('title')
	);

	register_post_type( 'swp_forms', $args );
}


function swp_add_info_sidebar() {

	global $post;
?>
<script type="text/javascript">
(function($) {

	$(function(){
// wrap
	$('#wpbody .wrap').attr('id', 'vcpopup-global');
	$('#vcpopup-global').wrapInner('<div id="vcpopup-global-col-left" />');
	$('#vcpopup-global').wrapInner('<div id="vcpopup-global-cols" />');

	// add sidebar
	$('#vcpopup-global-cols').prepend( $('#tmpl-vcpopup-global-col-right').html() );
	// take out h2 + icon
	$('#vcpopup-global-col-left > .icon32').insertBefore('#vcpopup-global-cols');
	$('#vcpopup-global-col-left > h2').insertBefore('#vcpopup-global-cols');

	})
})(jQuery);
</script>
		<?php

}


function swp_add_info_sidebar_html() {

	$version = swp_get_version();

?>
<script type="text/html" id="tmpl-vcpopup-global-col-right">
<div id="vcpopup-global-col-right">

	<div class="wp-box">
		<div class="inner">
			<h2><?php _e( "Sendy Widget Pro", 'vcpn' ); ?> <?php echo $version; ?></h2>

			<h3><?php _e( "Changelog", 'vcpn' ); ?></h3>
			<p><?php _e( "See what's new in", 'vcpn' ); ?> <a target="_blank" href="http://codecanyon.net/item/sendy-widget-pro/6215362?ref=webholics#item-description__changelog"><?php _e( "version", 'vcpn' ); ?> <?php echo $version; ?></a>

			<h3><?php _e( "Other Plugins", 'vcpn' ); ?></h3>
			<ul>
				<li style="float: left;margin-right: 20px;"><a href="http://codecanyon.net/item/visual-composer-mailchimp-addon/11556987?ref=webholics" target="_blank"><img src="https://0.s3.envato.com/files/135121326/vc-mailchimp-thumb.jpg"></a></li>
				<li><a href="http://codecanyon.net/item/visual-composer-icon-tabs/8321724?ref=webholics" target="_blank"><img src="https://0.s3.envato.com/files/98200763/vc-icontabs-thumb.jpg"></a></li>

			</ul>
		</div>
		<div class="footer footer-blue">
			<ul class="hl">
				<li><?php _e( "Created by", 'vcpn' ); ?><a target="_blank" href="http://codecanyon.net/user/webholics/portfolio?ref=webholics"> Webholics</a></li>
			</ul>
		</div>
	</div>
</div>
</script>

<?php

}

function swp_remove_edit_trash_links( $actions, $post ) {
	if ( $post->post_type =='swp_forms' ) {
		unset( $actions['view'] );
		unset( $actions['inline hide-if-no-js'] );
		unset( $actions['edit_vc'] );
	}
	return $actions;
}

function swp_remove_date_coloumn( $columns ) {
	unset( $columns['date'] );
	$columns['shortcode'] = __( 'Shortcode', 'swp_forms' );
	return $columns;
}


function swp_get_version() {
	if ( SENDY_WIDGET_PRO_VER ) {
		return 'v'.SENDY_WIDGET_PRO_VER;
	}else {
		return '';
	}

}

add_action( 'manage_swp_forms_posts_custom_column' , 'swp_shortcode_column', 10, 2 );


function swp_shortcode_column( $column, $post_id ) {
    switch ( $column ) {

        case 'shortcode' :
             echo '[swp-forms id='.$post_id.']';
            break;

    }
}


