<?php

add_action( 'vc_before_init', 'add_sendy_addon_to_vc' );

/*Adds the Sendy Form option to VC*/
function add_sendy_addon_to_vc() {

	// Check if Visual Composer is installed
	if ( ! defined( 'WPB_VC_VERSION' ) || ! function_exists( 'wpb_map' ) ) {

		return;

	}

	$sendy_lists_array[__( "No List found.", "js_composer" )] = '';
	$sendy_lists=get_option( 'sendy_lists' );
	if ( $sendy_lists ) {
		$sendy_lists_array = array( __( "Select List.", "js_composer" ) => '' );
		foreach ( $sendy_lists as $key=>$name ) {
			$sendy_lists_array[$name]= $key;
		}
	}

	vc_map( array(
			"name" => __( "Sendy Form Deprecated", "swp" ),
			"base" => "subscribe-sendy-form",
			"icon" => "icon-swp",
			"category" => __( "Content", "swp" ),
			"description" => __( 'Add Sendy Form to Subscribe users', 'swp' ),
			"admin_enqueue_css" => array( plugins_url( 'css/swp-admin-vc.css', __FILE__ ) ),
			"params" => array(

				array(
					"type" => "dropdown",
					"heading" => __( "Select List", "swp" ),
					"param_name" => "id",
					"value" => $sendy_lists_array,
					"description" => __( "Select a List to which you want users to subscribe.", "swp" ),
					"admin_label" => true
				),

				array(
					'type' => 'dropdown',
					'heading' => __( 'Show Name field', 'swp' ),
					'param_name' => 'name',
					'value' =>  array(
						'No' => 'false',
						'Yes' => 'true',

					)
				),
				array(
					'type' => 'dropdown',
					'heading' => __( 'Enable Captcha', 'swp' ),
					'param_name' => 'captcha',
					'value' =>  array(
						'No' => 'false',
						'Yes' => 'true',

					)
				),

				array(
					'type' => 'dropdown',
					'heading' => __( 'Show T&C', 'swp' ),
					'param_name' => 'terms',
					'description' => __( 'Show terms and conditions checkbox.', 'vcab' ),
					'value' =>  array(
						'No' => 'false',
						'Yes' => 'true',

					)
				),
				array(
					'type' => 'dropdown',
					'heading' => __( 'Show Subscriber Count', 'swp' ),
					'param_name' => 'subscribers',

					'value' =>  array(
						'No' => 'false',
						'Yes' => 'true',

					)
				),


			)


		)
	);

}
