<?php
class SWP_Form_layout_Settings {

	private static $style_setting;

	function __construct() {
		add_action( 'swp_form_layout_settings', array( $this, 'create_form_layout_settings' ) );
	}

	//Plugin starting point.
	public static function setup() {
		$class = __CLASS__;
		new $class;
	}

	public static function create_form_layout_settings( $form_id ) {
		$style_setting = get_post_meta( $form_id, 'swp_styler_settings', true );
		$custom_fields = get_option( 'swp_custom_fields' );
		$translation = get_option( 'sendy_translation_settings' );
		$sendy_recaptcha = get_option( 'sendy_recaptcha' );

		$active_fields=array();
		if ( !empty(  $style_setting['field_layout']  ) &&  $style_setting['field_layout']!='[]'  ) {
			$field_layout_settings =self::get_styler_field_layout_settings( $form_id );
			foreach ( $field_layout_settings as $field_id => $field_layout ) {
				$field_id = str_replace( 'swp_styler_field_layout_', '', $field_id );
				$active_fields[]=$field_id;
			}
		}

		//print_r($active_fields); die;
?>
		<div class="add_field_cont">
		<ul id="swp-layout-fields">
		<!-- Name field -->
		<li>
		<a data-type="" class="<?php echo in_array( '2', $active_fields )?'disabled':''; ?>" data-id="2" href="javascript:void(0)"><?php echo $translation['name']; ?></a>
		</li>
		<!-- Recaptcha field -->
		<?php if ( !empty( $sendy_recaptcha['site_key'] ) && !empty( $sendy_recaptcha['site_key'] ) ) { ?>
		<li>
		<a data-type="" class="<?php echo in_array( '4', $active_fields )?'disabled':''; ?>" data-id="4" href="javascript:void(0)">reCAPTCHA</a>
		</li>
		<?php } ?>
        <!-- Terms Checkbox -->
		<li>
		<a data-type="" class="<?php echo in_array( '5', $active_fields )?'disabled':''; ?>" data-id="5" href="javascript:void(0)">Optin Checkbox</a>
		</li>
      <!--  Subscribe Count -->
		<li>
		<a data-type="" class="<?php echo in_array( '6', $active_fields )?'disabled':''; ?>" data-id="6" href="javascript:void(0)">Subscribe Count</a>
		</li>

		<?php if ( !empty( $custom_fields ) ) {
			foreach ( $custom_fields as $key => $custom_field ) { ?>
			<li>
				<a class="<?php echo  in_array( $key, $active_fields )?'disabled':''; ?>" data-type="<?php  echo $custom_field['type']; ?>" data-id="<?php echo $key; ?>" href="javascript:void(0)"><?php echo $custom_field['label']; ?></a>
			</li>

			<?php
			}
		}
?>
</ul>
		</div>
		<div id="layoutstyler">
	<div class="layoutstyler-rt-cont gridster ">
	<input type="hidden" id="field-layout-data" name="styler[field_layout]" value="">
	<ul class="menu layoutstylerfield-list" >
<?php  if ( !empty(  $style_setting['field_layout']  ) &&  $style_setting['field_layout']!='[]'  ) {


			foreach ( $field_layout_settings as $field_id => $field_layout ) {
				$field_id = str_replace( 'swp_styler_field_layout_', '', $field_id );
				if ( $field_id=='1' ) {
					$label = $translation['email'];
					$type = 'Email';
				}elseif ( $field_id=='2' ) {
					$label = $translation['name'];
					$type = 'Name';
				}elseif ( $field_id=='3' ) {
					$label = 'Submit';
					$type = 'Submit';
				}elseif (  $field_id=='4' ) {
					if ( !empty( $sendy_recaptcha['site_key'] ) && !empty( $sendy_recaptcha['secret_key'] ) ) {
						$label = 'reCAPTCHA';
						$type = '';
					}else {
						continue;
					}
				}elseif ( $field_id =='5' ) {
					$label = 'Optin Checkbox';
					$type = 'Checkbox';
				}elseif ( $field_id =='6' ) {
					$label = 'Subscribe Count';
					$type = '';
				}else {
					if ( ! isset( $custom_fields[$field_id] ) ) { continue;}
					$label = $custom_fields[$field_id]['label'];
					$type = $custom_fields[$field_id]['type'];
				}

?>

		<li  data-row="<?php echo $field_layout->row; ?>" data-col="<?php echo $field_layout->col; ?>" data-sizex="<?php echo $field_layout->size_x; ?>" data-sizey="<?php echo $field_layout->size_y; ?>" id="<?php echo $field_id; ?>" class=" ninja-forms-no-nest _text-li">

				<dl class="menu-item-bar">
					<dt class="menu-item-handle">
						<span class="item-title ninja-forms-field-title" ><?php echo $label; ?></span>
						<span class="item-controls">
							<span class="item-type"><span class="spinner" style="margin-top: -2px; float: left; display: none;"></span><span class="item-type-name"><?php echo $type; ?></span>
							<?php if ( !in_array( $field_id, array( 1, 3 ) ) ) { ?>
							<a class="remove-field" data-id="<?php echo $field_id; ?>" href="javascript:void(0)"><span class="dashicons dashicons-no"></span></a>
							<?php } ?>
							</span>

						</span>
					</dt>
				</dl>

</li>
	<?php }

		}else { ?>
	<li  data-row="1" data-col="1" data-sizex="1" data-sizey="1" id="swp_styler_field_layout_1" class=" ninja-forms-no-nest _text-li">

				<dl class="menu-item-bar">
					<dt class="menu-item-handle">
						<span class="item-title ninja-forms-field-title" ><?php echo $translation['email']; ?></span>
						<span class="item-controls">
							<span class="item-type"><span class="spinner" style="margin-top: -2px; float: left; display: none;"></span><span class="item-type-name">Email</span></span>
						</span>
					</dt>
				</dl>

</li>

	<li  data-row="1" data-col="1" data-sizex="1" data-sizey="1" id="swp_styler_field_layout_3" class=" ninja-forms-no-nest _text-li">

				<dl class="menu-item-bar">
					<dt class="menu-item-handle" >
						<span class="item-title ninja-forms-field-title"><?php echo $translation['subscribe_button']; ?></span>
						<span class="item-controls">
							<span class="item-type"><span class="spinner" style="margin-top: -2px; float: left; display: none;"></span><span class="item-type-name">Submit</span></span>
						</span>
					</dt>
				</dl>

</li>
<?php } ?>
		</ul>


	</div>
	</div>
	<?php }

	public static function get_styler_field_layout_settings( $form_id ) {
		$field_layout = $field_layout_settings = array();
		$style_setting = get_post_meta( $form_id, 'swp_styler_settings', true );
		if ( !empty( $style_setting['field_layout']  ) ) {
			$field_layout = json_decode( stripslashes( $style_setting['field_layout'] ) );
			//debug($field_layout);
			foreach ( $field_layout as $layout_array ) {
				foreach ( $layout_array as $key => $obj ) {
					$field_layout_settings[$key] = $obj;
				}
			}
		}

		return $field_layout_settings;
	}


}
